/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.parameter;

import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Console;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import server.restful.common.parameter.ServletConsole;
import server.restful.common.parameter.usage.ServletUsageFormatter;

public class ServletParameterParser {
    private static final List<String> VALUE_ABSENT = Arrays.asList("", "null", "undefined");
    private final JCommander commander;
    private final ServletUsageFormatter usageFormatter;

    public ServletParameterParser(HttpServletRequest request, HttpServletResponse response, Object parameterObject) throws IOException {
        this(request, response, parameterObject, false);
    }

    public ServletParameterParser(HttpServletRequest request, HttpServletResponse response, Object parameterObject, boolean acceptUnknownOptions) throws IOException {
        this.commander = JCommander.newBuilder().addObject(parameterObject).programName(request.getServletPath()).columnSize(Integer.MAX_VALUE).console((Console)new ServletConsole(response)).acceptUnknownOptions(acceptUnknownOptions).build();
        this.usageFormatter = new ServletUsageFormatter(this.commander, request, response);
        this.commander.setUsageFormatter((IUsageFormatter)this.usageFormatter);
        try {
            this.commander.parse(ServletParameterParser.getRequestParametersAsCommandLine(request));
        }
        catch (ParameterException e) {
            this.setException((Exception)((Object)e));
        }
    }

    public void usage() {
        this.commander.usage();
    }

    public void setException(Exception exception) {
        this.usageFormatter.setException(exception);
    }

    public boolean hasException() {
        return this.usageFormatter.getException() != null;
    }

    public static String[] getRequestParametersAsCommandLine(HttpServletRequest request) {
        return (String[])Stream.concat(Collections.list(request.getParameterNames()).stream().flatMap(name -> Arrays.asList(request.getParameterValues(name)).stream().filter(v -> VALUE_ABSENT.stream().noneMatch(v::equals)).map(v -> Stream.of((name.length() > 1 ? "--" : "-") + name, v))).flatMap(Function.identity()), Optional.ofNullable(request.getPathInfo()).map(Stream::of).orElse(Stream.empty())).toArray(String[]::new);
    }
}

